#!/bin/sh
# --------------------------------------------------------
# --- Script:  copy and unpack update sound files  ------
# --- Version: 1.00 --------------------------------------
# --- Datum:   25.09.2010 --------------------------------
# --- Autor:   Max Schreiber / Andre Naggies -------------
# --------------------------------------------------------
##########################################################

# comment out if you don't want to update sound files
# exit 0

source ./upd_function.sh

GetKernelVersion
krnl_vers=$?
if [ $krnl_vers -lt 9 ] ; then
    updDir=/usr/local/data
else
    updDir=/usr/local/prg
fi

# loesche alte files und lege verzeichnis an
#
if [ -e $updDir/tmpsound ]; then
    if rm $updDir/tmpsound/* ; then
        echo "rm $updDir/tmpsound/* success"
    fi
else
    if mkdir $updDir/tmpsound -p ; then
	echo "mkdir $updDir/tmpsound -p success"
    else
        echo -e "error script upd_sound.sh \n\r"
        exit 6
    fi
fi

# Kopiere Sound files Update
#
echo -e "copy new soundfiles package... \n\r"
if [ -e sound_viper.tar.gz ]; then
    if cp sound_viper.tar.gz $updDir/tmpsound/ ; then
        echo -e "cp sound_viper.tar.gz file success \n\r"
        if gzip -d $updDir/tmpsound/sound_viper.tar.gz ; then
            echo -e "gzip sound_viper.tar.gz success \n\r"
            if tar -xf $updDir/tmpsound/sound_viper.tar -C $updDir/tmpsound/ ; then
                echo -e "tar sound_viper.tar success \n\r"
                if [ -e $updDir/tmpsound/upd_sound.sh ]; then
                    if $updDir/tmpsound/upd_sound.sh $updDir/tmpsound ; then
                        echo -e "$updDir/tmpsound/upd_sound.sh success \n\r"
                        if rm -rf $updDir/tmpsound ; then
                            echo "rm $updDir/tmpsound success"
                        fi
                        echo -e "end script upd_sound_viper.sh \n\r"
                        exit 0
                    else
                        echo -e "error script upd_sound_viper.sh \n\r"
                        exit 6
                    fi
                else
                    echo -e "error script upd_sound_viper.sh \n\r"
                    exit 5
                fi
            else
                echo -e "error script upd_sound_viper.sh \n\r"
                exit 4
            fi
        else
            echo -e "error script upd_sound_viper.sh \n\r"
            exit 3
        fi
    else
        echo -e "error script upd_sound_viper.sh \n\r"
        exit 2
    fi
else
    echo -e "error script upd_sound_viper.sh \n\r"
    exit 5
fi

echo -e "error script upd_sound_viper.sh \n\r"
exit -1

