#!/bin/sh
# --------------------------------------------------------
# --- Script:  remove prg; DB; settings;.. / old files  --
# --- Version: 1.00 --------------------------------------
# --- Datum:   25.09.2010 --------------------------------
# --- Autor:   Max Schreiber / Andre Naggies -------------
# --------------------------------------------------------
##########################################################
# comment out if you don't want to update program
# exit 0

# loesche alte Programm Dateien
#
echo -e "remove user program ... \n\r"
for x in dr3900 dr3900_ng dr6000 dr6000_ng mpptp mpptp_ng hpptp hpptp_ng lcp6 lcp6_ng bt_tp bt_tp_ng tu5200 tu5200_ng ; do
    if [ -e /usr/local/prg/$x ]; then
        echo -e "$x found -> start removing...\n\r"
        if rm /usr/local/prg/$x ; then
            echo "rm $x success"
        fi
    fi
    if [ -e /usr/local/data/${x}_version ]; then
        echo -e "${x}_version found -> start removing...\n\r"
        if rm /usr/local/data/${x}_version ; then
            echo "rm ${x}_version success"
        fi
    fi
    if [ -e /usr/local/prg/version/${x}_version ]; then
        echo -e "${x}_version found -> start removing...\n\r"
        if rm /usr/local/prg/version/${x}_version ; then
            echo "rm ${x}_version success"
        fi
    fi
    if [ -e /usr/local/data/${x}_version.skip ]; then
        echo -e "${x}_version.skip found -> start removing...\n\r"
        if rm /usr/local/data/${x}_version.skip ; then
            echo "rm ${x}_version.skip success"
        fi
    fi
done 

# loesche alte .gz Dateien
#
echo -e "remove .gz files ... \n\r"
for x in dr3900 dr3900_ng dr6000 dr6000_ng mpptp mpptp_ng hpptp hpptp_ng lcp6 lcp6_ng bt_tp bt_tp_ng tu5200 tu5200_ng ; do
    if [ -e /usr/local/prg/${x}.gz ]; then
        echo -e "${x}.gz found -> start removing...\n\r"
        if rm /usr/local/prg/${x}.gz ; then
            echo "rm ${x}.gz success"
        fi
    fi
done


# loesche alte Daten Dateien
#
if [ -e /usr/local/data/DBHL ]; then
    if rm -rf /usr/local/data/DBHL/* ; then
        echo "rm -rf /usr/local/data/DBHL/* success"
    fi
fi
if [ -e /usr/local/data/DBBC ]; then
    if rm /usr/local/data/DBBC/* ; then
        echo "rm /usr/local/data/DBBC/* success"
    fi
fi
if [ -e /usr/local/data/Instrument_ENV_Data ]; then
    if rm /usr/local/data/Instrument_ENV_Data ; then
        echo "rm /usr/local/data/Instrument_ENV_Data success"
    fi
fi
if [ -e /usr/local/data/Sample_Data ]; then
    if rm /usr/local/data/Sample_Data ; then
        echo "rm /usr/local/data/Sample_Data success"
    fi
fi
if [ -e /usr/local/data/Sample100_Data ]; then
    if rm /usr/local/data/Sample100_Data ; then
        echo "rm /usr/local/data/Sample100_Data success"
    fi
fi
if [ -e /usr/local/data/Unit_Data ]; then
    if rm /usr/local/data/Unit_Data ; then
        echo "rm /usr/local/data/Unit_Data success"
    fi
fi
if [ -e /usr/local/data/Operator_Data ]; then
    if rm /usr/local/data/Operator_Data ; then
        echo "rm /usr/local/data/Operator_Data success"
    fi
fi
if [ -e /usr/local/data/Password_Data ]; then
    if rm /usr/local/data/Password_Data ; then
        echo "rm /usr/local/data/Password_Data success"
    fi
fi
if [ -e /usr/local/data/SingleWave_ENV_Data ]; then
    if rm /usr/local/data/SingleWave_ENV_Data ; then
        echo "rm /usr/local/data/SingleWave_ENV_Data success"
    fi
fi
if [ -e /usr/local/data/MultiWave_ENV_Data ]; then
    if rm /usr/local/data/MultiWave_ENV_Data ; then
        echo "rm /usr/local/data/MultiWave_ENV_Data success"
    fi
fi
if [ -e /usr/local/data/WavelengthScan_ENV_Data ]; then
    if rm /usr/local/data/WavelengthScan_ENV_Data ; then
        echo "rm /usr/local/data/WavelengthScan_ENV_Data success"
    fi
fi
if [ -e /usr/local/data/TimeCourse_ENV_Data ]; then
    if rm /usr/local/data/TimeCourse_ENV_Data ; then
        echo "rm /usr/local/data/TimeCourse_ENV_Data success"
    fi
fi
if [ -e /usr/local/data/ServiceTime_ENV_Data ]; then
    if rm /usr/local/data/ServiceTime_ENV_Data ; then
        echo "rm /usr/local/data/ServiceTime_ENV_Data success"
    fi
fi
if [ -e /usr/local/data/AQA_Setup_Data ]; then
    if rm /usr/local/data/AQA_Setup_Data ; then
        echo "rm /usr/local/data/AQA_Setup_Data success"
    fi
fi
if [ -e /usr/local/data/Standards_Data ]; then
    if rm /usr/local/data/Standards_Data ; then
        echo "rm /usr/local/data/Standards_Data success"
    fi
fi
if [ -e /usr/local/data/Trends_Data ]; then
    if rm /usr/local/data/Trends_Data ; then
        echo "rm /usr/local/data/Trends_Data success"
    fi
fi
if [ -e /usr/local/data/Ratios_Data ]; then
    if rm /usr/local/data/Ratios_Data ; then
        echo "rm /usr/local/data/Ratios_Data success"
    fi
fi
if [ -e /usr/local/data/VerificationKit_Data ]; then
    if rm /usr/local/data/VerificationKit_Data ; then
        echo "rm /usr/local/data/VerificationKit_Data success"
    fi
fi
if [ -e /usr/local/data/TestSolutionSet_Data ]; then
    if rm /usr/local/data/TestSolutionSet_Data ; then
        echo "rm /usr/local/data/TestSolutionSet_Data success"
    fi
fi
if [ -e /usr/local/data/verify ]; then
    if rm -rf /usr/local/data/verify/* ; then
        echo "rm -rf /usr/local/data/verify/* success"
    fi
fi
if [ -e /usr/local/data/solution ]; then
    if rm -rf /usr/local/data/solution/* ; then
        echo "rm -rf /usr/local/data/solution/* success"
    fi
fi
if [ -e /usr/local/data/PipetteTest ]; then
    if rm -rf /usr/local/data/PipetteTest/* ; then
        echo "rm -rf /usr/local/data/PipetteTest/* success"
    fi
fi

if [ -e /usr/local/data/L2SC ]; then
    if rm -rf /usr/local/data/L2SC/* ; then
        echo "rm -rf /usr/local/data/L2SC/* success"
    fi
fi
if [ -e /usr/local/data/L2SC_history ]; then
    if rm -rf /usr/local/data/L2SC_history/* ; then
        echo "rm -rf /usr/local/data/L2SC_history/* success"
    fi
fi

if [ -e /usr/local/data/DataLog ]; then
    if rm /usr/local/data/DataLog ; then
        echo "rm /usr/local/data/DataLog success"
    fi
fi
if [ -e /usr/local/data/NewDataLog ]; then
    if rm /usr/local/data/NewDataLog ; then
        echo "rm /usr/local/data/NewDataLog success"
    fi
fi
if [ -e /usr/local/data/Scan ]; then
    if rm -rf /usr/local/data/Scan/* ; then
        echo "rm -rf /usr/local/data/Scan/* success"
    fi
fi
if [ -e /usr/local/data/tScan ]; then
    if rm -rf /usr/local/data/tScan/* ; then
        echo "rm -rf /usr/local/data/tScan/* success"
    fi
fi

if [ -e /usr/local/data/Lico_ENV_Data ]; then
    if rm /usr/local/data/Lico_ENV_Data ; then
        echo "rm /usr/local/data/Lico_ENV_Data success"
    fi
fi
if [ -e /usr/local/data/Lico_Config_Data ]; then
    if rm /usr/local/data/Lico_Config_Data ; then
        echo "rm /usr/local/data/Lico_Config_Data success"
    fi
fi
if [ -e /usr/local/data/Lico_RefData_Data ]; then
    if rm /usr/local/data/Lico_RefData_Data ; then
        echo "rm /usr/local/data/Lico_RefData_Data success"
    fi
fi
if [ -e /usr/local/data/ColorLog ]; then
    if rm /usr/local/data/ColorLog ; then
        echo "rm /usr/local/data/ColorLog success"
    fi
fi
if [ -e /usr/local/data/Color_Standards ]; then
    if rm /usr/local/data/Color_Standards ; then
        echo "rm /usr/local/data/Color_Standards success"
    fi
fi
if [ -e /usr/local/data/NewColorLog ]; then
    if rm /usr/local/data/NewColorLog ; then
        echo "rm /usr/local/data/NewColorLog success"
    fi
fi
if [ -e /usr/local/data/AQAColor_Data ]; then
    if rm /usr/local/data/AQAColor_Data ; then
        echo "rm /usr/local/data/AQAColor_Data success"
    fi
fi
if [ -e /usr/local/data/ColTrends_Data ]; then
    if rm /usr/local/data/ColTrends_Data ; then
        echo "rm /usr/local/data/ColTrends_Data success"
    fi
fi
if [ -e /usr/local/data/ActCalCurve ]; then
    if rm /usr/local/data/ActCalCurve ; then
        echo "rm /usr/local/data/ActCalCurve success"
    fi
fi
if [ -e /usr/local/data/ReadLog ]; then
    if rm /usr/local/data/ReadLog ; then
        echo "rm /usr/local/data/ReadLog success"
    fi
fi
if [ -e /usr/local/data/VerifyLog ]; then
    if rm /usr/local/data/VerifyLog ; then
        echo "rm /usr/local/data/VerifyLog success"
    fi
fi
if [ -e /usr/local/data/CompareLog ]; then
    if rm /usr/local/data/CompareLog ; then
        echo "rm /usr/local/data/CompareLog success"
    fi
fi
if [ -e /usr/local/data/CalLog ]; then
    if rm /usr/local/data/CalLog ; then
        echo "rm /usr/local/data/CalLog success"
    fi
fi
if [ -e /usr/local/data/L2scPSM.conf ]; then
    if rm /usr/local/data/L2scPSM.conf ; then
        echo "rm /usr/local/data/L2scPSM.conf success"
    fi
fi

if [ -e /usr/local/data/docs ]; then
    if rm -rf /usr/local/data/docs/* ; then
        echo "rm -rf /usr/local/data/docs/* success"
    fi
fi

# remove guide in case device type is changed from dr3900 to lcp
# (In kernel_version < #9 the guide_version is placed in /usr/local/data/guide
#  folder. Therefore no extra deletion of version file was needed.)
##############################################################################
if [ -e /usr/local/data/guide ]; then
    if rm -rf /usr/local/data/guide/* ; then
        echo "rm -rf /usr/local/data/guide/* success"
    fi
fi
if [ -e /usr/local/prg/version/guide_version ]; then
    if rm -rf /usr/local/prg/version/guide_version ; then 
        echo "rm -rf /usr/local/prg/version/guide_version success"
    fi
fi
if [ -e /usr/local/prg/guide ]; then
    if rm -rf /usr/local/prg/guide/* ; then
        echo "rm -rf /usr/local/prg/guide/* success"
    fi
fi

if [ -e /usr/local/data/cups/extern_ppd ]; then
    if rm -rf /usr/local/data/cups/extern_ppd/* ; then
        echo "rm -rf /usr/local/data/cups/extern_ppd/* success"
    fi
fi

echo -e "end remove old stuff ... \n\r"

