#!/bin/sh
# --------------------------------------------------------
# --- Script:  update sw packages for viper  -------------
# --- Version: 1.00 --------------------------------------
# --- Datum:   27.09.2010 --------------------------------
# --- Autor:   Max Schreiber -----------------------------
# --------------------------------------------------------
##########################################################
# To be called as follows:
# e.g. "upd_prg_viper.sh -r -d/usr/local/data/tmp -pdr3900"
# -r : clean up (TP only)
# -d : where *.tar or *.zip was unpacked to
# -p : program to be updated
###############################################

# comment out if you don't want to update program
#################################################
# exit 0

source ./upd_function.sh

GetKernelVersion
krnl_vers=$?
mkdir -p /usr/local/prg/version
mkdir -p /var/lock # needed by fw_printenv

# echo ADDED TEMPORARILY FOR DEBUGGING START
# mkdir -p /mnt/sda1/log
# cp -rf /var/log/* /mnt/sda1/log/.

# rm -f /etc/selinux/config
# echo SELINUX=disabled    > /etc/selinux/config
# echo SELINUXTYPE=hach   >> /etc/selinux/config
# echo SETLOCALDEFS=0     >> /etc/selinux/config
# echo ADDED TEMPORARILY FOR DEBUGGING END

# cmd line
##########
echo UPDATE CMD LINE: $*

# retrieve ARG update dir
#########################
upddir=$(echo $* | grep -o '\-d/[^ ]*' | grep -o '/[^ ]*')
if [ -e $upddir ]; then
    cd $upddir
else
    echo $0: $upddir not available
    exit $UPD_ERR_CD
fi

# retrieve ARG program
######################
prg=$(echo $* | grep -o '\-p[^ ]*')
len=`expr length $prg - 1`
prg=$(echo $prg | tail -c $len)

# retrieve ARG kernel update request
####################################
bKernelUpdate=0
echo $* | grep "\-k" > /dev/null
if [ $? -eq 0 ] ; then
    echo $0: kernel update requested
    bKernelUpdate=1
else
    echo $0: kernel update not requested
fi

# retrieve ARG device type
##########################
devtyp=$(echo $* | grep -o '\-t[^ ]*' | grep -o '[0-9][^ ]*')
if [ $devtyp ]; then
    echo $0: device type is $devtyp
else
    # DFLT: invalid device type
    echo $0: default device type is 0 - invalid
    devtyp=0
fi

for x in bt_tp bt_tp_ng tu5200 tu5200_ng; do
    if [ $x = $prg ]; then # strcmp: "="
	# retrieve ARG language
	#######################
	language=$(echo $* | grep -o '\-l[^ ]*' | grep -o '[0-9][^ ]*')
	if [ $language ]; then 
	    echo $0: language is $language
	else
	    if [ $krnl_vers -lt 9 ] ; then
		artNr=$(uboot_env | grep art_nr)
	    else
		artNr=$(fw_printenv art_nr)
	    fi
	    if [ $artNr ]; then
		language=${artNr:14:2}
		echo $0: language from uboot_env is $language
	    else
		# DFLT: undefined language
		echo $0: default language is 99
		language=99
	    fi
	fi

	# retrieve ARG EPA/ISO (for TU5200)
	###################################
	lighttype=$(echo $* | grep -o '\-epa[^ ]*' | grep -o '[epa][^ ]*')
	if [ $lighttype ]; then
	    echo $0: lighttype is $lighttype
	else
	    lighttype=$(echo $* | grep -o '\-iso[^ ]*' | grep -o '[iso][^ ]*')
	    if [ $lighttype ]; then
		echo $0: lighttype is $lighttype
	    else
		if [ $krnl_vers -lt 9 ] ; then
		    artNr=$(uboot_env | grep art_nr)
		else
		    artNr=$(fw_printenv art_nr) 
		fi
		if [ ${artNr:20:1} -eq 1 ]; then
		    lighttype=epa
		elif [ ${artNr:20:1} -eq 2 ]; then
		    lighttype=iso
		else
		    lighttype=none
		fi
		echo $0: lighttype from uboot_env is $lighttype
	    fi
	fi
    fi
done

# retrieve ARG step (see UPD_CO_...)
####################################
step=$(echo $* | grep -o '\-s[^ ]*')
if [ $step ]; then
    len=`expr length $step - 1`
    step=$(echo $step | tail -c $len)
    echo $0: update $prg step $step from $upddir
else
    echo $0: update $prg from $upddir
    step=$UPD_CO_SCRIPT_ALL
fi

# program specific handling
###########################
case "$prg" in
    dr3900 | dr3900_ng)
        dbase="dbhlm"
        ;;
    dr6000 | dr6000_ng)
        dbase="dbhlh"
        ;;
    *)
        dbase="none"
        ;;
esac


# clean up (-r: DO NOT remove all)
##################################
if [ $step -eq $UPD_CO_CLEAN -o $step -eq $UPD_CO_SCRIPT_ALL ]; then

    echo $* | grep "\-r" > /dev/null
    if [ $? -eq 0 ] ; then
        echo $0: -r option: DO NOT call upd_rm_viper.sh
    else
        if [ -x upd_rm_viper.sh ]; then
            echo $0: call upd_rm_viper.sh...
            ./upd_rm_viper.sh
            
            echo "unlock nor..."
            cd /sys/class/gpio
            echo 121 >export
            cd gpio121
            echo high >direction
            flash_unlock /dev/mtd2
            
            # update logo (only when remove script is called)
            #################################################
            # DEVICE_TYPE_HACH    (= 1)
            # DEVICE_TYPE_VWR_EDU (= 12)
            for x in 1 12; do
                if [ $devtyp -eq $x ] ; then
                    if [ "$prg" == "tu5200" ] && [ -e ${upddir}/HACH_NEW_800x480x565.uzb ] ; then
                        echo "update boot logo..."
			if [ $krnl_vers -lt 9 ] ; then
                            update_flash ${upddir}/HACH_NEW_800x480x565.uzb 2
			else
			    flashcp ${upddir}/HACH_NEW_800x480x565.uzb /dev/mtd2
			fi
                    else
                        if [ -e ${upddir}/HACH_800x480x565.uzb ] ; then
                            echo "update boot logo..."
			    if [ $krnl_vers -lt 9 ] ; then
				update_flash ${upddir}/HACH_800x480x565.uzb 2
			    else
				flashcp ${upddir}/HACH_800x480x565.uzb /dev/mtd2
			    fi
                        fi
                    fi    
                fi
            done
            # DEVICE_TYPE_HACH_LANGE (= 2)
            # DEVICE_TYPE_HL_LICO690 (= 7)
            # DEVICE_TYPE_HL_LICO620 (= 10)
            for x in 2 7 10; do
                if [ $devtyp -eq $x ] ; then 
                    if [ -e ${upddir}/HACH_800x480x565.uzb ] ; then
                        echo "update boot logo..."
			if [ $krnl_vers -lt 9 ] ; then
                            update_flash ${upddir}/HACH_800x480x565.uzb 2
			else
			    flashcp ${upddir}/HACH_800x480x565.uzb /dev/mtd2
			fi
                    fi
                fi
            done
            #DEVICE_TYPE_BYK_LCSIV (= 8)
            #DEVICE_TYPE_BYK_LCMIV (= 11)
            for x in 8 11; do
                if [ $devtyp -eq $x ] ; then 
                    if [ -e ${upddir}/BYK_800x480x565.uzb ] ; then
                        echo "update boot logo..."
			if [ $krnl_vers -lt 9 ] ; then
                            update_flash ${upddir}/BYK_800x480x565.uzb 2
			else
			    flashcp ${upddir}/BYK_800x480x565.uzb /dev/mtd2
			fi
                    fi
                fi
            done
            echo "lock nor..."
            echo low >direction
            flash_lock /dev/mtd2 0 -1
            
            # in case of tu5200 write WDT logo
            # (for DR3900, DR6000, Lico6x0 this is handled in app because of camera crash handling)
            case "$prg" in
                tu5200)
                    # update wdt logo
                    #################
                    if [ $krnl_vers -ge 9 ]; then
                        echo "unlock nor..."
                        cd /sys/class/gpio
                        echo 121 >export
                        cd gpio121
                        echo high >direction
                        
                        echo "update WDT logo..."
                        flash_unlock /dev/mtd3
                        flashcp ${upddir}/WDT_800x480x565.uzb /dev/mtd3
                        
                        echo "lock nor..."
                        echo low >direction
                        flash_lock /dev/mtd3 0 -1
                    fi
                    ;;
                *)
                    echo ""
                    ;;
            esac
        fi
    fi
fi
if [ $step -gt $UPD_CO_CLEAN ]; then
    echo ""
else
    exit $UPD_OK
fi

# update general START (dummy script for future updates)
########################################################
if [ $step -eq $UPD_CO_GENERAL_START -o $step -eq $UPD_CO_SCRIPT_ALL ]; then
    cd ${upddir}
    if [ -x upd_general_start_viper.sh ]; then
        echo $0: call upd_general_start_viper.sh...
        if ./upd_general_start_viper.sh $prg $step $bKernelUpdate ; then
            echo $0: execute 'upd_general_start_viper.sh' success
        else
            echo $0: execute 'upd_general_start_viper.sh' failed
            exit $UPD_ERR_GENERAL_START
        fi
    fi
fi
if [ $step -gt $UPD_CO_GENERAL_START ]; then
    echo ""
else
    exit $UPD_OK
fi

# check existence (if requested) 
################################
if [ $step -eq $UPD_CO_CHECK_PRG ]; then
    if [ -x $prg -o -e $prg.gz ]; then
        echo $0: check $prg success
        exit $UPD_OK
    else
        echo $0: check $prg failed
        exit $UPD_ERR_NO_PRG
    fi
fi
if [ $step -eq $UPD_CO_CHECK_DB ]; then
    if [ -e $dbase.tar.gz -o $dbase = "none" ]; then
        echo $0: check $dbase.tar.gz success
        exit $UPD_OK
    else
        echo $0: check $dbase.tar.gz failed
        exit $UPD_ERR_NO_DB
    fi
fi
if [ $step -eq $UPD_CO_CHECK_LNG ]; then
    if [ -x upd_lng_viper.sh ]; then
        echo $0: check upd_lng_viper.sh success
        exit $UPD_OK
    else
        echo $0: check upd_lng_viper.sh failed
        exit $UPD_ERR_NO_LNG
    fi
fi
if [ $step -eq $UPD_CO_CHECK_DRV ]; then
    if [ -x upd_drv_viper.sh ]; then
        echo $0: check upd_drv_viper.sh success
        exit $UPD_OK
    else
        echo $0: check upd_drv_viper.sh failed
        exit $UPD_ERR_NO_DRV
    fi
fi
if [ $step -eq $UPD_CO_CHECK_GUIDE ]; then
    if [ -x upd_guide_viper.sh ]; then
        echo $0: check upd_guide_viper.sh success
        exit $UPD_OK
    else
        echo $0: check upd_guide_viper.sh failed
        exit $UPD_ERR_NO_GUIDE
    fi
fi
if [ $step -eq $UPD_CO_CHECK_SOUND ]; then
    if [ -x upd_sound_viper.sh ]; then
        echo $0: check upd_sound_viper.sh success
        exit $UPD_OK
    else
        echo $0: check upd_sound_viper.sh not found
        exit $UPD_OK
        # -> Sound update is not required
        ##################################
        # exit $UPD_ERR_NO_SOUND
    fi
fi
if [ $step -eq $UPD_CO_CHECK_GENERAL_END ]; then
    if [ -x upd_general_end_viper.sh ]; then
        echo $0: check upd_general_end_viper.sh success
        exit $UPD_OK
    else
        echo $0: check upd_general_end_viper.sh failed
        exit $UPD_ERR_NO_GENERAL_END
    fi
fi


# update tp (step variable doesn't matter for tp)
#################################################
for x in mpptp mpptp_ng hpptp hpptp_ng bt_tp bt_tp_ng; do
    if [ $x = $prg ]; then # strcmp: "="
        
        # copy tp
        ###########################
        if [ -x $upddir/$prg ]; then
            if cp $upddir/$prg /usr/local/prg/. ; then
                echo $0: update $prg success
            else
                echo $0: update $prg failed
                exit $UPD_ERR_COPY_PRG
            fi
        fi
        
        # update driver
        ###############
        cd ${upddir}
        if [ -x upd_drv_viper.sh ]; then
            echo $0: call upd_drv_viper.sh...
            if ./upd_drv_viper.sh $prg ; then
                echo $0: upd_drv_viper.sh success
            else
                echo $0: upd_drv_viper.sh failed
                exit $UPD_ERR_DRV_SCRIPT
            fi
        else
            echo $0: test exist upd_drv_viper.sh failed
        fi

        # update sound
        #############################
        CheckVersion sound_version
        if [ $? -eq 1 ] ; then
            if [ -x upd_sound_viper.sh ]; then
		if [ -e sound_viper.tar.gz ]; then
		    echo $0: call upd_sound_viper.sh...
		    if ./upd_sound_viper.sh ; then
			echo $0: upd_sound_viper.sh success
		    else
			echo $0: upd_sound_viper.sh failed
			exit $UPD_ERR_SOUND_SCRIPT
		    fi
		else
		    echo  $0: update file 'sound_viper.tar.gz' not found
		    # Sound update is not required
		    # -> no error message if tar.gz is not available
		fi
	    else
		echo $0: update file 'upd_sound_viper.sh' not found
		# Sound update is not required
		# -> no error message if script is not available
            fi
	else
            echo $0: skip update sound
        fi
	
        # remove standby application
        ##############################
        if [ -x /usr/local/prg/standby ]; then
            if rm /usr/local/prg/standby ; then
                echo $0: remove '/usr/local/prg/standby' success
            else
                echo $0: remove '/usr/local/prg/standby' failed
            fi
        fi
    else
        if [ -e /usr/local/prg/$x ] ; then
            if rm -rf /usr/local/prg/$x ; then
                echo $0: remove '/usr/local/prg/$x' success
            else
                echo $0: remove '/usr/local/prg/$x' failed
            fi
        fi
    fi
done

# update ui
###########
for x in dr3900 dr3900_ng dr6000 dr6000_ng lcp6 lcp6_ng tu5200 tu5200_ng; do
    if [ $x = $prg ]; then # strcmp: "="
        # update prg
        ############
        if [ $step -eq $UPD_CO_PRG -o $step -eq $UPD_CO_SCRIPT_ALL ]; then
            # remove existing markerfile from last update trial
            ###################################################
            rm -f /tmp/ui_update_done
            ui_update=1
            
            # allow downgrade only in case of 'allow_downgrade' file
            ########################################################
            if [ ! -e /mnt/sda1/allow_downgrade ] ; then
                # allow update with same version (for testing and repair purposes)
                CheckVersion ${prg}_version -le
                if [ $? -ne 1 ] ; then
                    ui_update=0
                fi
            fi
            if [ $ui_update -eq 1 ]; then
                if gunzip -t $prg.gz ; then
                    echo $0: test $prg.gz success
                    if cp $prg.gz /usr/local/prg/. ; then
                        echo $0: cp $prg.gz to /usr/local/prg success
                        
                        # remove old prg
                        ################
                        if [ -e /usr/local/prg/$prg ]; then
                            if rm -f /usr/local/prg/$prg ; then
                                echo $0: remove old $prg success
                            else
                                echo $0: remove old $prg failed
                                exit $UPD_ERR_GZIP
                            fi
                        fi
                        
                        # unzip prg
                        ###########
                        if gzip -df /usr/local/prg/$prg.gz ; then
			    # mark successfull prg-update for copying version-file at the end of upd-process
			    ################################################################################
                            touch /tmp/ui_update_done
                            echo $0: gzip $prg.gz success
                        else
                            echo $0: gzip $prg.gz failed
                            exit $UPD_ERR_GZIP
                        fi
                    else
                        echo $0: cp $prg.gz to /usr/local/prg failed
                        exit $UPD_ERR_COPY_GZ
                    fi
                else
                    echo $0: test $prg.gz failed
                    exit $UPD_ERR_GZIP
                fi
            fi
        fi
        if [ $step -gt $UPD_CO_PRG ]; then
            echo ""
        else
            exit $UPD_OK
        fi
        
        # update db
        ###########
        if [ $step -eq $UPD_CO_DB -o $step -eq $UPD_CO_SCRIPT_ALL ]; then
            if [ $dbase = "none" ]; then
                echo $0: lcp6,tu5200: no database to install
            else
                if [ -e $dbase.tar.gz ]; then
                    if cp $dbase.tar.gz /usr/local/data/DBHL/. ; then
                        echo $0: cp $dbase.tar.gz to /usr/local/data/DBHL success
                        if gzip -df /usr/local/data/DBHL/$dbase.tar.gz ; then
                            echo $0: gzip $dbase.tar.gz success
                            if tar -xf /usr/local/data/DBHL/$dbase.tar -C /usr/local/data/DBHL/ ; then
                                echo $0: tar $dbase.tar success
                                if rm /usr/local/data/DBHL/$dbase.tar ; then
                                    echo $0: rm /usr/local/data/DBHL/$dbase.tar success
                                else
                                    echo $0: rm /usr/local/data/DBHL/$dbase.tar failed
                                    exit $UPD_OK # no critical error
                                fi
                            else
                                echo $0: tar $dbase.tar.gz failed
                                exit $UPD_ERR_TAR
                            fi
                        else
                            echo $0: gzip $dbase.tar.gz failed
                            exit $UPD_ERR_GZIP
                        fi
                    else
                        echo $0: cp $dbase.tar.gz to /usr/local/data/DBHL failed
                        exit $UPD_ERR_COPY_GZ
                    fi
                else
                    echo $0: test exist $dbase.tar.gz failed
                    exit $UPD_ERR_NO_DB
                fi
            fi
        fi
        if [ $step -gt $UPD_CO_DB ]; then
            echo ""
        else
            exit $UPD_OK
        fi
        
        # update lng
        ############
        if [ $step -eq $UPD_CO_LNG -o $step -eq $UPD_CO_SCRIPT_ALL ]; then
            if [ -x upd_lng_viper.sh ]; then
                echo $0: call upd_lng_viper.sh...
                if ./upd_lng_viper.sh $prg ; then
                    echo $0: upd_lng_viper.sh success
                else
                    echo $0: upd_lng_viper.sh failed
                    exit $UPD_ERR_LNG_SCRIPT
                fi
            else
                echo $0: text exist upd_lng_viper.sh failed
                exit $UPD_ERR_NO_SCRIPT
            fi
        fi
        if [ $step -gt $UPD_CO_LNG ]; then
            echo ""
        else
            exit $UPD_OK
        fi

        # update driver
        ###############
        if [ $step -eq $UPD_CO_DRV -o $step -eq $UPD_CO_SCRIPT_ALL ]; then
            cd ${upddir}
            if [ -x upd_drv_viper.sh ]; then
                echo $0: call upd_drv_viper.sh...
                if ./upd_drv_viper.sh $prg ; then
                    echo $0: upd_drv_viper.sh success
                else
                    echo $0: upd_drv_viper.sh failed
                    exit $UPD_ERR_DRV_SCRIPT
                fi
            else
                echo $0: test exist upd_drv_viper.sh failed
                exit $UPD_ERR_NO_SCRIPT
            fi
        fi
        if [ $step -gt $UPD_CO_DRV ]; then
            echo ""
        else
            exit $UPD_OK
        fi

        # update help guide
        ###################
        if [ $step -eq $UPD_CO_GUIDE -o $step -eq $UPD_CO_SCRIPT_ALL ]; then
            if [ $dbase = "none" ]; then
                echo $0: lcp6,tu5200: no help guide to install
            else
                cd ${upddir}
                CheckVersion guide_version
                if [ $? -eq 1 ] ; then
                    echo $0: update guide
                    if [ -x upd_guide_viper.sh ]; then
                        echo $0: call upd_guide_viper.sh...
                        if ./upd_guide_viper.sh ; then
                            echo $0: upd_guide_viper.sh success
                        else
                            echo $0: upd_guide_viper.sh failed
                            exit $UPD_ERR_GUIDE_SCRIPT
                        fi
                    else
                        echo $0: test exist upd_guide_viper.sh failed
                        exit $UPD_ERR_NO_SCRIPT
                    fi
                else
                    echo $0: skip update guide
                fi
            fi
        fi
        if [ $step -gt $UPD_CO_GUIDE ]; then
            echo ""
        else
            exit $UPD_OK
        fi
        
        # update sound
        #################
        if [ $step -eq $UPD_CO_SOUND -o $step -eq $UPD_CO_SCRIPT_ALL ]; then
            cd ${upddir}
            CheckVersion sound_version
            if [ $? -eq 1 ] ; then
                if [ -x upd_sound_viper.sh ]; then
		    if [ -e sound_viper.tar.gz ]; then
			echo $0: call upd_sound_viper.sh...
			if ./upd_sound_viper.sh ; then
                            echo $0: upd_sound_viper.sh success
			else
                            echo $0: upd_sound_viper.sh failed
                            exit $UPD_ERR_SOUND_SCRIPT
			fi
                    else
			echo  $0: update file 'sound_viper.tar.gz' not found
			# Sound update is not required
			# -> no error message if tar.gz is not available
                    fi
		else
		    echo $0: update file 'upd_sound_viper.sh' not found
		    # Sound update is not required
		    # -> no error message if script is not available
		fi
            else
                echo $0: skip update sound
            fi
        fi
        if [ $step -gt $UPD_CO_SOUND ]; then
            echo ""
        else
            exit $UPD_OK
        fi
    else
        if [ -e /usr/local/prg/$x ] ; then
            if rm -rf /usr/local/prg/$x ; then
                echo $0: remove '/usr/local/prg/$x' success
            else
                echo $0: remove '/usr/local/prg/$x' failed
            fi
        fi
    fi
done

# update general files END (dummy script for future updates)
############################################################
if [ $step -eq $UPD_CO_GENERAL_END -o $step -eq $UPD_CO_SCRIPT_ALL ]; then
    cd ${upddir}
    if [ -x upd_general_end_viper.sh ]; then
        echo $0: call upd_general_end_viper.sh...
        if ./upd_general_end_viper.sh $prg ; then
            echo $0: upd_general_end_viper.sh success
        else
            echo $0: upd_general_end_viper.sh failed
            exit $UPD_ERR_GENERAL_END_SCRIPT
        fi
    else
        echo $0: test exist upd_general_end_viper.sh failed
        exit $UPD_ERR_NO_SCRIPT
    fi
    if [ -e /tmp/ui_update_done ]; then
	if [ -e ${prg}_version ]; then
	    echo $0: write update package version...
	    if [ $krnl_vers -lt 9 ] ; then
		cp -f ${prg}_version /usr/local/data/.
	    else
		cp -f ${prg}_version /usr/local/prg/version/.
	    fi
	fi
    fi
    for x in bt_tp bt_tp_ng tu5200 tu5200_ng; do
        if [ $x = $prg ]; then # strcmp: "="
            if [ -e /mnt/sda1/manual ] && [ $lighttype != none ]; then
                mkdir -p /usr/local/data/manuals
		echo "Remove old user manuals..."
		rm -f /usr/local/data/manuals/*.pdf
		# 40 Taiwan
		# 42 Lithuania 
		# 43 Croatia
		# 44 Slovenia
		# 45 Estonia
		# 47 Serbia 
		# 48 Greece
		# 51 Switzerland (DE)
		# 52 English version with EU plug for international use
		# 53 USA
		# 56 Netherlands
		# 57 Italy
		# 58 Denmark
		# 59 Sweden
		# 60 Poland
		# 61 Spain
		# 62 Russia
		# 63 Finland
		# 66 Australia / New Zealand
		# 69 Morocco
		# 71 Austria
		# 72 Germany and Austria
		# 77 France (Combination)
		# 78 Belgium (NL)
		# 79 Portugal
		# 80 China
		# 81 Japan
		# 82 Great Britain
		# 83 Great Britain
		# 84 South Korea
		# 85 Czech Republic
		# 86 Hungary
		# 87 Romania
		# 88 Slovakia
		# 89 Bulgaria
		# 90 Brazil (Portuguese)
		# 91 Canada (French)
		# 92 South America (Spanish)
		# 94 Turkey
		# 97 USA (ROW)
		
		echo "Copy new user manuals..."
		
                # english (always install english ROW)
                UpdateManual 53 $lighttype

                # single nation to language type (standard)
                for y in 40 42 43 44 45 47 48 52 56 57 58 59 60 61 62 63 72 77 79 80 81 84 85 86 87 88 89 90 91 92 93 94; do
                    if [ $language = $y ]; then
                        UpdateManual $y $lighttype
                    fi
                done
                
                # Additionally for Belgium (NL)
                for y in 78; do
                    if [ $y = $language ]; then
			# Netherlands
                        UpdateManual 56 $lighttype
                    fi
                done

                # Additionally for Switzerland (DE)
                for y in 51; do
                    if [ $y = $language ]; then
			# Italian
                        UpdateManual 57 $lighttype
                    fi
                done
                
                # Additionally for Switzerland (DE), Austria
                for y in 00 51 71; do
                    if [ $y = $language ]; then
			# German
                        UpdateManual 72 $lighttype
                    fi
                done
                
                # Additionally for Switzerland (DE), Morocco, Belgium (NL)
                for y in 51 69 78; do
                    if [ $y = $language ]; then
			# France (Combination)
                        UpdateManual 77 $lighttype
                    fi
                done
		
		# Additionally for USA (ROW)
		for y in 53 97; do
                    if [ $y = $language ]; then
			# China
			UpdateManual 80 $lighttype
			# Japan
                        UpdateManual 81 $lighttype
			# South Korea
			UpdateManual 84 $lighttype
			# Brazil (Portuguese)
			UpdateManual 90 $lighttype
			# Canada (French)
			UpdateManual 91 $lighttype
			# South America (Spanish)
			UpdateManual 92 $lighttype
                    fi
                done
            fi
        fi
    done
    
    TU5200Video="DOC202.53.90559*.avi"
    if [ -e /mnt/sda1/manual ] ; then
	mkdir -p /usr/local/data/videos
	echo "Remove old videos..."
	rm -f /usr/local/data/videos/*.avi
	for x in bt_tp bt_tp_ng tu5200 tu5200_ng; do
	    if [ $x = $prg ]; then # strcmp: "="
		echo "Copy new videos..."
		if [ -e /mnt/sda1/manual/${TU5200Video} ] ; then
		    if cp -f /mnt/sda1/manual/${TU5200Video} /usr/local/data/videos/. ; then
			echo "Update videos: ${TU5200Video} success"
		    else
			echo "Update videos: ${TU5200Video} failed"
			exit $UPD_ERR_NO_SCRIPT
		    fi					
		fi
	    fi
	done
    fi
fi

# fix hw_revision (for r73 boards)
##################################
if [ $krnl_vers -ge 9 ]; then
    hw_rev=$(fw_printenv hw_revision | cut -d "=" -f2)
    hw_rev_num=$(echo $hw_rev | grep -o -E '[0-9]+')
    hw_sn=$(fw_printenv hw_serial_nr | cut -d "=" -f2)
    bootargs_hw_rev=$(fw_printenv bootargs_linux_post | cut -d "=" -f3)
    
    echo "$0: HW-SN:  $hw_sn, HW-REV: $hw_rev"
    echo "$0: BOOT-HW-REV: $bootargs_hw_rev"

    if [ -z ${hw_sn} ]; then
        echo "$0: ERR: NO HW-SN: CANT FIX HW-REV"
    else        
        if [ ${hw_rev_num} -lt 73 ]; then
	    if [ ${hw_sn} -ge 133954 ]; then
	        fw_setenv hw_revision r73
	        rslt=$(echo $?)
	        if [ ${rslt} -eq 0 ]; then
		    echo "$0: OK: HW_REV SET TO R73"
	        else
		    echo "$0: ERR: CANT FIX HW-REV"
	        fi
            else
	        echo "$0: OK: NO FIX NEEDED FOR HW-REV"
	    fi
        else
	    echo "$0: OK: NO FIX NEEDED FOR HW-REV"
        fi
    fi
    
    if [ $bootargs_hw_rev == '${hw_revision}' ]; then 
	echo "$0: OK: NO FIX NEEDED FOR BOOT-HW-REV"
    else
        fw_setenv bootargs_linux_post hw_revision=\${hw_revision}
	rslt=$(echo $?)
	if [ ${rslt} -eq 0 ]; then
	    echo "$0: OK: BOOT-HW-REV SET TO REFERENCE"
	else
	    echo "$0: ERR: CANT FIX BOOT_HW_REV"
	fi
    fi
else
    echo "$0: KRNL: $krnl_vers"
    echo "$0: OK: NO FIX for hw_revision NEEDED"
fi

# clean update directories
##########################
echo $0: remove tmp, tmpdrv directories
if [ $krnl_vers -lt 9 ] ; then
    rm -rf /usr/local/prg/tmp*
else
    rm -rf /usr/local/data/tmp*
fi
rm -rf /tmp/update
cd

# exit script
echo $0: update $* complete
exit 0
