#!/bin/sh
# --------------------------------------------------------
# --- Script:  copy and unpack language files  -----------
# --- Version: 1.00 --------------------------------------
# --- Datum:   01.10.2010 --------------------------------
# --- Autor:   Max Schreiber / Andre Naggies -------------
# --------------------------------------------------------
##########################################################
# comment out if you don't want to update language
# exit 0
updpkg=$1
if [ $updpkg = "lcp6" ] || [ "$updpkg" = "lcp6_ng" ] ; then
    lng_file="lng_lcp"
else
    lng_file="lng_viper"
fi

GetKernelVersion() {
    if [ -e /tmp/NEW_KERNEL_MARKER ] ; then
	krnl_vers=$(cat /tmp/NEW_KERNEL_MARKER)
    else
	krnl_vers=$(uname -v)
	krnl_vers=${krnl_vers%% *} # cut off everything after ' '
    fi
    krnl_vers=${krnl_vers#*#}  # cut off everything upto '#'
    if [ $krnl_vers -lt 7 ] ; then
	krnl_vers=7;
    fi
    return $krnl_vers
}

GetKernelVersion
krnl_vers=$?


# loesche alte sprachfiles und lege verzeichnis an
#
if [ -e /usr/local/prg/lng ]; then
    if rm /usr/local/prg/lng/* ; then
        echo -e "rm /usr/local/prg/lng/* success \n\r"
    fi
else
    if mkdir /usr/local/prg/lng -p ; then
	echo -e "mkdir /usr/local/prg/lng -p success \n\r"
    else
        echo -e "error script upd_lng_viper.sh \n\r"
        exit 6
    fi
fi

# kopiere neue sprachfiles
#
echo -e "copy new language files ... \n\r"
if [ -e $lng_file.tar.gz ]; then
    if cp $lng_file.tar.gz /usr/local/prg/lng/ ; then
        echo -e "cp $lng_file.tar.gz file success \n\r"
        if gzip -d /usr/local/prg/lng/$lng_file.tar.gz ; then
            echo -e "gzip $lng_file.tar.gz success \n\r"
            if tar -xf /usr/local/prg/lng/$lng_file.tar -C /usr/local/prg/lng/ ; then
                echo -e "tar $lng_file.tar success \n\r"
                if [ $krnl_vers -ge 9 ] ; then
                    echo -e "mv lng_version to ../prg/version folder"
                    mv -f /usr/local/prg/lng/*_version /usr/local/prg/version/.
                fi
                if rm -f /usr/local/prg/lng/$lng_file.tar ; then
                    echo -e "rm /usr/local/prg/lng/$lng_file.tar success \n\r"
                    echo -e "end script upd_lng_viper.sh \n\r"
                    exit 0
                else
                    echo -e "error script upd_lng_viper.sh \n\r"
                    exit -1
                fi
            else
                echo -e "error script upd_lng_viper.sh \n\r"
                exit 4
            fi
        else
            echo -e "error script upd_lng_viper.sh \n\r"
            exit 3
        fi
    else
        echo -e "error script upd_lng_viper.sh \n\r"
        exit 2
    fi
else
    echo -e "error script upd_lng_viper.sh \n\r"
    exit 5
fi

echo -e "error script upd_lng_viper.sh \n\r"
exit -1

