#!/bin/sh
# --------------------------------------------------------
# --- Script:  copy and unpack update helpguide  ---------
# --- Version: 1.00 --------------------------------------
# --- Datum:   25.09.2010 --------------------------------
# --- Autor:   Max Schreiber / Andre Naggies -------------
# --------------------------------------------------------
##########################################################
# comment out if you don't want to update driver
# exit 0

source ./upd_function.sh
GetKernelVersion
krnl_vers=$?
if [ $krnl_vers -lt 9 ] ; then
    updDir=/usr/local/data
else
    updDir=/usr/local/prg
fi

# loesche alte files und lege verzeichnis an
#

if [ -e $updDir/tmpguide ]; then
    if rm $updDir/tmpguide/* ; then
        echo "rm $updDir/tmpguide/* success"
    fi
else
    if mkdir $updDir/tmpguide -p ; then
	echo "mkdir $updDir/tmpguide -p success"
    else
        echo -e "error script upd_guide_viper.sh \n\r"
        exit 6
    fi
fi

# kopiere HelpGuide
#
echo -e "copy new helpguide package ... \n\r"
if [ -e guide.tar.gz ]; then
    if cp guide.tar.gz $updDir/tmpguide/ ; then
        echo -e "cp guide.tar.gz file success \n\r"
        if gzip -d $updDir/tmpguide/guide.tar.gz ; then
            echo -e "gzip guide.tar.gz success \n\r"
            if tar -xf $updDir/tmpguide/guide.tar -C $updDir/tmpguide/ ; then
                echo -e "tar guide.tar success \n\r"
                if [ -e $updDir/tmpguide/upd_guide.sh ]; then
                    if $updDir/tmpguide/upd_guide.sh ; then
                        echo -e "$updDir/tmpguide/upd_guide.sh success \n\r"
                        if rm -rf $updDir/tmpguide ; then
                            echo "rm $updDir/tmpguide success"
                        fi
                        echo -e "end script upd_guide_viper.sh \n\r"
                        exit 0
                    else
                        echo -e "error script upd_guide_viper.sh \n\r"
                        exit 6
                    fi
                else
                    echo -e "error script upd_guide_viper.sh \n\r"
                    exit 5
                fi
            else
                echo -e "error script upd_guide_viper.sh \n\r"
                exit 4
            fi
        else
            echo -e "error script upd_guide_viper.sh \n\r"
            exit 3
        fi
    else
        echo -e "error script upd_guide_viper.sh \n\r"
        exit 2
    fi
else
    echo -e "error script upd_guide_viper.sh \n\r"
    exit 5
fi

echo -e "error script upd_guide_viper.sh \n\r"
exit -1

