#!/bin/sh
# --------------------------------------------------------
# --- Script:  general updates for viper  ----------------
# --- Version: 0.01 --------------------------------------
# --- Datum:   25.09.2010 --------------------------------
# --- Autor:   Max Schreiber / Andre Naggies -------------
# --------------------------------------------------------
##########################################################
# comment out if you don't want to update general files
# exit 0

echo $0

board_type=$(fw_printenv board | cut -d "=" -f2) > /dev/null 2>&1

prg=$1
step=$2
bKernelUpdate=$3

upddir=$(pwd)
tmpdir=/mnt/sda1/kernel_update # do not place in appfs as it is deleted in kernel update

source ./upd_function.sh

GetKernelVersion
krnl_vers=$?
if [ $krnl_vers -lt 9 ] ; then
    selinux=selinux8
else
    selinux=selinux9
fi

# clean up
##########
if [ ${upddir} != "/mnt/sda1" ] ; then
    if [ -e ${prg}.tar ] ; then
        echo $0: REMOVE ${prg}.tar
        rm -f ${prg}.tar
    fi
fi

# update SH4 kernel (must be before all because appfs is rewritten)
###############################################################
if [ ! "$board_type" == "stm32mp1" ]; then
	if [ $bKernelUpdate -eq 1 ]; then
	    if [ $step -eq $UPD_CO_SCRIPT_ALL ]; then # update kernel only if started from TP
		if [ -e kernel.tar.gz ]; then
		    # Allow forced update of same kernel
		    # CheckVersion kernel_version 
		    # if [ $? -eq 1 ] ; then
		    echo "update kernel"
		    AssertDir $tmpdir
		    if [ $? -eq 1 ] ; then
			if gzip -dc kernel.tar.gz > $tmpdir/kernel.tar ; then
			    echo "gzip kernel.tar.gz success"
			    if tar -xf $tmpdir/kernel.tar -C $tmpdir ; then
				echo "tar kernel.tar success"
				rm -f $tmpdir/kernel.tar
				if [ -e $tmpdir/kernel.sh ] ; then
				    if $tmpdir/kernel.sh $prg $tmpdir ; then
					echo $tmpdir/kernel.sh success
				    else
					echo "$0: error updating kernel (5)"
					exit 5
				    fi
				else
				    echo "$0: error updating kernel (4)"
				    exit 4
				fi
			    else
				echo "$0: error updating kernel (3)"
				exit 3
			    fi
			else
			    echo "$0: error updating kernel (2)"
			    exit 2
			fi
		    else
			echo "$0: error updating kernel (3)"
			exit 1
		    fi
		    # else
		    #   echo "$0: skip update kernel (installed version=$krnl_vers)"
		    # fi
		else
		    echo "$0: skip update kernel (missing kernel.tar.gz)"
		fi
	    else
		echo "$0: skip update kernel (wrong step=$step)"
	    fi
	fi
else 
# update Viper_STM32 kernel 
###############################################################
	if [ $bKernelUpdate -eq 1 ]; then
	    if [ $step -eq $UPD_CO_SCRIPT_ALL ]; then # update kernel only if started from TP
		if [ -e kernel_ng.tar.gz ]; then
		    echo "Update kernel for viper_stm32"
		    AssertDir $tmpdir
		    if [ $? -eq 1 ] ; then
			if gzip -dc kernel_ng.tar.gz > $tmpdir/kernel_ng.tar ; then
			    echo "gzip kernel_ng.tar.gz success"
			    if tar -xf $tmpdir/kernel_ng.tar -C $tmpdir ; then
				echo "tar kernel_ng.tar success"
				rm -f $tmpdir/kernel_ng.tar
				if [ -e $tmpdir/kernel_ng.sh ] ; then
				    if $tmpdir/kernel_ng.sh $prg $tmpdir ; then
					echo $tmpdir/kernel_ng.sh success
				    else
					echo "$0: error updating kernel (5)"
					exit 5
				    fi
				else
				    echo "$0: error updating kernel (4)"
				    exit 4
				fi
			    else
				echo "$0: error updating kernel (3)"
				exit 3
			    fi
			else
			    echo "$0: error updating kernel (2)"
			    exit 2
			fi
		    else
			echo "$0: error updating kernel (3)"
			exit 1
		    fi
		else
		    echo "$0: skip update kernel (missing kernel_ng.tar.gz)"
		fi
	    else
		echo "$0: skip update kernel (wrong step=$step)"
	    fi
	fi
fi

RemoveDir $tmpdir # remove after reboot

# update selinux (only SH4 board, must be before drv_viper because busybox needs libselinux)
############################################################################
if [ ! "$board_type" == "stm32mp1" ]; then
	if [ -e ${selinux}.tar.gz ]; then
	    CheckVersion selinux_version
	    if [ $? -eq 1 ] ; then
		echo -e "update SELINUX"
		if  cp -f ${selinux}.tar.gz /. ; then
		    echo -e "cp ${selinux}.tar.gz file success \n\r"
		    cd /.
		    if [ -e ${selinux}.tar ]; then
		        rm -f ${selinux}.tar
		    fi
		    if gzip -d ${selinux}.tar.gz ; then
		        echo -e "gzip ${selinux}.tar.gz success \n\r"
		        if tar -xf ${selinux}.tar ; then
		            echo -e "tar ${selinux}.tar success \n\r"
		            rm -f ${selinux}.tar
		        else
		            echo -e "$0: error updating ${selinux} (4)\n\r"
		            exit 4
		        fi
		    else
		        echo -e "$0: error updating ${selinux} (3)\n\r"
		        exit 3
		    fi
		else
		    echo -e "$0: error updating ${selinux} (2)\n\r"
		    exit 2
		fi
	    else
		echo -e "$0: skip update ${selinux}\n\r"
	    fi
	fi
fi

# hier koennen weitere updates eingetragen werden....

echo -e "finished 'upd_general_start_viper.sh' \n\r"
exit 0
