#!/bin/sh
# --------------------------------------------------------
# --- Script:  general updates for viper  ------
# --- Version: 0.01 --------------------------------------
# --- Datum:   25.09.2010 --------------------------------
# --- Autor:   Max Schreiber / Andre Naggies -------------
# --------------------------------------------------------
##########################################################
# comment out if you don't want to update general files
# exit 0

prg=$1

board_type=$(fw_printenv board | cut -d "=" -f2) > /dev/null 2>&1

source ./upd_function.sh

GetKernelVersion
krnl_vers=$?
if [ $krnl_vers -lt 9 ] ; then
    updateDir=/usr/local/data
else
    updateDir=/usr/local/prg
fi



# update pdfconv (by now only on SH4 platform)
################
if [ ! "$board_type" == "stm32mp1" ]; then
    echo -e "update pdfconv"

    CheckVersion pdfconv_version
    if [ $? -eq 1 ] ; then
        echo $0: update pdfconv
        
        # loesche alte files und lege verzeichnis an
        if [ -e $updateDir/tmppdf ]; then
            if rm -rf $updateDir/tmppdf/* ; then
                echo "rm $updateDir/tmppdf/* success"
            fi
        else
            if mkdir $updateDir/tmppdf -p ; then
                echo "mkdir $updateDir/tmppdf -p success"
            else
                echo -e "$0: error updating pdfconv (7)\n\r"
                exit 7
            fi
        fi
        
        # kopiere pdf converter update
        echo -e "copy new pdfconv ... \n\r"
        if [ -e pdfconv.tar.gz ]; then
            if cp pdfconv.tar.gz $updateDir/tmppdf/ ; then
                echo -e "cp pdfconv.tar.gz file success \n\r"
                if gzip -d $updateDir/tmppdf/pdfconv.tar.gz ; then
                    echo -e "gzip pdfconv.tar.gz success \n\r"
                    if tar -xf $updateDir/tmppdf/pdfconv.tar -C $updateDir/tmppdf/ ; then
                        echo -e "tar pdfconv.tar success \n\r"
                        rm -f $updateDir/tmppdf/pdfconv.tar
                        if [ -e $updateDir/tmppdf/pdfconv.sh ]; then
                            if $updateDir/tmppdf/pdfconv.sh ; then
                                echo -e "$updateDir/tmppdf/pdfconv.sh success \n\r"
                                if rm -rf $updateDir/tmppdf ; then
                                    echo "rm $updateDir/tmppdf success"
                                fi
                                echo -e "$0: updating pdfconv done\n\r"
                            else
                                echo -e "$0: error updating pdfconv (6)\n\r"
                                exit 6
                            fi
                        else
                            echo -e "$0: error updating pdfconv (5)\n\r"
                            exit 5
                        fi
                    else
                        echo -e "$0: error updating pdfconv (4)\n\r"
                        exit 4
                    fi
                else
                    echo -e "$0: error updating pdfconv (3)\n\r"
                    exit 3
                fi
            else
                echo -e "$0: error updating pdfconv (2)\n\r"
                exit 2
            fi
        else
            echo -e "$0: error updating pdfconv (1)\n\r"
            exit 1
        fi
    else
        echo $0: skip update pdfconv
    fi
fi

# if [ $prg = "dr3900" ]; then
#     echo -e "finished upd_general_end_viper.sh \n\r"
#     exit 0
# fi

# update printing_base (by now only on SH4 platform)
#####################
if [ ! "$board_type" == "stm32mp1" ]; then
    echo -e "update printing_base"

    CheckVersion printing_base_version
    if [ $? -eq 1 ] ; then
        echo $0: update printing_base
        
        # loesche alte files und lege verzeichnis an
        if [ -e $updateDir/tmpprnt_base ]; then
            if rm -rf $updateDir/tmpprnt_base/* ; then
                echo "rm $updateDir/tmpprnt_base/* success"
            fi
        else
            if mkdir $updateDir/tmpprnt_base -p ; then
                echo "mkdir $updateDir/tmpprnt_base -p success"
            else
                echo -e "$0: error updating printing_base (7)\n\r"
                exit 7
            fi
        fi

        # kopiere printer base update
        echo -e "copy new printing_base ... \n\r"
        if [ -e printing_base.tar.gz ]; then
            if cp printing_base.tar.gz $updateDir/tmpprnt_base/ ; then
                echo -e "cp printing_base.tar.gz file success \n\r"
                if gzip -d $updateDir/tmpprnt_base/printing_base.tar.gz ; then
                    echo -e "gzip printing_base.tar.gz success \n\r"
                    if tar -xf $updateDir/tmpprnt_base/printing_base.tar -C $updateDir/tmpprnt_base/ ; then
                        echo -e "tar printing_base.tar success \n\r"
                        rm -f $updateDir/tmpprnt_base/printing_base.tar
                        if [ -e $updateDir/tmpprnt_base/printing_base.sh ]; then
                            if $updateDir/tmpprnt_base/printing_base.sh ; then
                                echo -e "$updateDir/tmpprnt_base/printing_base.sh success \n\r"
                                if rm -rf $updateDir/tmpprnt_base ; then
                                    echo "rm $updateDir/tmpprnt_base success"
                                fi
                                echo -e "$0: updating printing_base done\n\r"
                            else
                                echo -e "$0: error updating printing_base (6)\n\r"
                                exit 6
                            fi
                        else
                            echo -e "$0: error updating printing_base (5)\n\r"
                            exit 5
                        fi
                    else
                        echo -e "$0: error updating printing_base (4)\n\r"
                        exit 4
                    fi
                else
                    echo -e "$0: error updating printing_base (3)\n\r"
                    exit 3
                fi
            else
                echo -e "$0: error updating printing_base (2)\n\r"
                exit 2
            fi
        else
            echo -e "$0: error updating printing_base (1)\n\r"
            exit 1
        fi
    else
        echo $0: skip update printing_base
    fi
fi

# update printing_driver (by now only on SH4 platform)
#####################
if [ ! "$board_type" == "stm32mp1" ]; then
    echo -e "update printing_driver"

    CheckVersion printing_driver_version
    if [ $? -eq 1 ] ; then
        echo $0: update printing_driver
        
        # loesche alte files und lege verzeichnis an
        if [ -e $updateDir/tmpprnt_drv ]; then
            if rm -rf $updateDir/tmpprnt_drv/* ; then
                echo "rm $updateDir/tmpprnt_drv/* success"
            fi
        else
            if mkdir $updateDir/tmpprnt_drv -p ; then
                echo "mkdir $updateDir/tmpprnt_drv -p success"
            else
                echo -e "$0: error updating printing_driver (7)\n\r"
                exit 7
            fi
        fi
        
        # loesche extern_ppd verzeichnis
        # if [ -e /usr/local/data/cups/extern_ppd ]; then
        #   if rm -rf /usr/local/data/cups/extern_ppd ; then
        #     echo "rm $updateDir/cups/extern_ppd success"
        #   fi
        # fi
        
    # kopiere printer driver update
        echo -e "copy new printing_driver ... \n\r"
        if [ -e printing_driver.tar.gz ]; then
            if cp printing_driver.tar.gz $updateDir/tmpprnt_drv/ ; then
                echo -e "cp printing_driver.tar.gz file success \n\r"
                if gzip -d $updateDir/tmpprnt_drv/printing_driver.tar.gz ; then
                    echo -e "gzip printing_driver.tar.gz success \n\r"
                    if tar -xf $updateDir/tmpprnt_drv/printing_driver.tar -C $updateDir/tmpprnt_drv/ ; then
                        echo -e "tar printing_driver.tar success \n\r"
                        rm -f $updateDir/tmpprnt_drv/printing_driver.tar
                        if [ -e $updateDir/tmpprnt_drv/printing_driver.sh ]; then
                            if $updateDir/tmpprnt_drv/printing_driver.sh ; then
                                echo -e "$updateDir/tmpprnt_drv/printing_driver.sh success \n\r"
                                if rm -rf $updateDir/tmpprnt_drv ; then
                                    echo "rm $updateDir/tmpprnt_drv success"
                                fi
                                echo -e "$0: updating printing_driver done\n\r"
                            else
                                echo -e "$0: error updating printing_driver (6)\n\r"
                                exit 6
                            fi
                        else
                            echo -e "$0: error updating printing_driver (5)\n\r"
                            exit 5
                        fi
                    else
                        echo -e "$0: error updating printing_driver (4)\n\r"
                        exit 4
                    fi
                else
                    echo -e "$0: error updating printing_driver (3)\n\r"
                    exit 3
                fi
            else
                echo -e "$0: error updating printing_driver (2)\n\r"
                exit 2
            fi
        else
            echo -e "$0: error updating printing_driver (1)\n\r"
            exit 1
        fi
    else
        echo $0: skip update printing_driver
    fi

    # Remove printer ppds we know to cause problems
    if [ -e $updateDir/cups/model/foo2zjs/HP-LaserJet_Pro_P1606dn.ppd.gz ]; then
        echo -e "rm HP P1606dn.ppd.gz\n\r"
        rm -f $updateDir/cups/model/foo2zjs/HP-LaserJet_Pro_P1606dn.ppd.gz
    fi

    # Call extern_ppd update script
    if [ -e /mnt/sda1/PPD/upd_ppd_viper.sh ] ; then
        echo -e "call /mnt/sda1/ppd/upd_ppd_viper.sh script\n\r"
        if /mnt/sda1/PPD/upd_ppd_viper.sh ; then
            echo -e "/mnt/sda1/ppd/upd_ppd_viper.sh success \n\r"
        else
            echo -e "$0: error in /mnt/sda1/ppd/upd_ppd_viper.sh \n\r"
        fi
    fi

fi

# Manual wird sonst nur mit VAA608 installiert, hier Hintertuer fuer Update
if [ -e /mnt/sda1/docs/upd_docs_viper.sh ] ; then
    echo -e "call /mnt/sda1/docs/upd_docs_viper.sh script\n\r"
    if /mnt/sda1/docs/upd_docs_viper.sh ; then
        echo -e "/mnt/sda1/docs/upd_docs_viper.sh success \n\r"
    else
        echo -e "$0: error in /mnt/sda1/docs/upd_docs_viper.sh \n\r"
    fi
fi


# update AU
###########
if [ $prg = "tu5200" -o $prg = "bt_tp" -o $prg = "tu5200_ng" -o $prg = "bt_tp_ng" ]; then
    echo -e "update turb_au"
    
    echo $0: update turb_au
    
    # loesche alte files und lege verzeichnis an
    if [ -e /tmp/yyx760.bin ]; then
        if rm -f /tmp/yyx760.bin ; then
            echo "rm /tmp/yyx760.bin success"
        fi
    fi
    
    # kopiere turb_au update
    echo -e "copy new turb_au ... \n\r"
    if [ -e yyx760.bin ]; then
        if cp yyx760.bin /tmp/. ; then
            echo -e "cp yyx760.bin file success \n\r"
        else
            echo -e "$0: error updating turb_au (5)\n\r"
            exit 5
        fi
    else
        if [ -e turb_au.tar.gz ]; then
            if cp turb_au.tar.gz /tmp/. ; then
                echo -e "cp turb_au.tar.gz file success \n\r"
                if gzip -d /tmp/turb_au.tar.gz ; then
                    echo -e "gzip turb_au.tar.gz success \n\r"
                    if tar -xf /tmp/turb_au.tar -C /tmp/ ; then
                        echo -e "tar turb_au.tar success \n\r"
                        rm -f /tmp/turb_au.tar
                    else
                        echo -e "$0: error updating turb_au (4)\n\r"
                        exit 4
                    fi
                else
                    echo -e "$0: error updating turb_au (3)\n\r"
                    exit 3
                fi
            else
                echo -e "$0: error updating turb_au (2)\n\r"
                exit 2
            fi
        else
            echo -e "$0: error updating turb_au (1)\n\r"
            exit 1
        fi
    fi
fi

# update PCSCD/CCID-USB-RFID-Reader (currently tu5200 only)
###########################################################
if [ $prg = "tu5200" -o $prg = "bt_tp" ]; then
    if [ -e pcscd.tar.gz ]; then
        CheckVersion pcscd_version
        if [ $? -eq 1 ] ; then
            echo -e "update CCID (USB RFID) driver"
            if  cp -f pcscd.tar.gz /. ; then
                echo -e "cp pcscd.tar.gz file success \n\r"
                cd /.
                if [ -e pcscd.tar ]; then
                    rm -f pcscd.tar
                fi
                if gzip -d pcscd.tar.gz ; then
                    echo -e "gzip pcscd.tar.gz success \n\r"
                    if tar -xf pcscd.tar ; then
                        echo -e "tar pcscd.tar success \n\r"
                        chmod 755 /usr/
                        chmod 755 /usr/sbin/
                        chmod 755 /usr/lib/
                        chmod 755 /usr/bin/
                        rm -f pcscd.tar
                    else
                        echo -e "$0: error updating pcscd (4)\n\r"
                        exit 4
                    fi
                else
                    echo -e "$0: error updating pcscd (3)\n\r"
                    exit 3
                fi
            else
                echo -e "$0: error updating pcscd (2)\n\r"
                exit 2
            fi
        else
            echo -e "$0: skip update pcscd\n\r"
        fi
    fi
fi

echo -e "finished upd_general_end_viper.sh \n\r"
exit 0
