# update steps (must be identical to SH_CO_Update.hpp)
######################################################
UPD_CO_CHECK_USB=1
UPD_CO_UNZIP=2
UPD_CO_UNTAR=3
UPD_CO_CLEAN=4
UPD_CO_GENERAL_START=5
UPD_CO_CHECK_PRG=6
UPD_CO_PRG=7
UPD_CO_CHECK_DB=8
UPD_CO_DB=9
UPD_CO_CHECK_LNG=10
UPD_CO_LNG=11
UPD_CO_CHECK_DRV=12
UPD_CO_DRV=13
UPD_CO_CHECK_GUIDE=14
UPD_CO_GUIDE=15
UPD_CO_CHECK_SOUND=16
UPD_CO_SOUND=17
UPD_CO_CHECK_GENERAL_END=18
UPD_CO_GENERAL_END=19
UPD_CO_SCRIPT_ALL=20

# update errors (must be identical to SH_CO_Update.hpp)
#######################################################
UPD_OK=0
UPD_ERR_CREATE_TMP_DIR=1
UPD_ERR_CLEAN_TMP_DIR=2
UPD_ERR_CD=3
UPD_ERR_COPY_ZIP=4
UPD_ERR_COPY_GZ=5
UPD_ERR_COPY_TAR=6
UPD_ERR_COPY_PRG=7
UPD_ERR_COPY_DB=8
UPD_ERR_COPY_LNG=9
UPD_ERR_COPY_DRV=10
UPD_ERR_COPY_SOUND=11
UPD_ERR_COPY_GUIDE=12
UPD_ERR_UNZIP=13
UPD_ERR_GZIP=14
UPD_ERR_TAR=15
UPD_ERR_NO_USB=16
UPD_ERR_NO_SCRIPT=17
UPD_ERR_NO_PRG=18
UPD_ERR_NO_DB=19
UPD_ERR_NO_LNG=20
UPD_ERR_NO_DRV=21
UPD_ERR_NO_GUIDE=22
UPD_ERR_NO_SOUND=23
UPD_ERR_NO_GENERAL_END=24
UPD_ERR_GENERAL_START_SCRIPT=25
UPD_ERR_LNG_SCRIPT=26
UPD_ERR_DRV_SCRIPT=27
UPD_ERR_GUIDE_SCRIPT=28
UPD_ERR_SOUND_SCRIPT=29
UPD_ERR_GENERAL_END_SCRIPT=30

AssertDir() {
    if [ -e $1 ]; then
	if rm -rf $1/* ; then
            echo "rm $1/* success"
	fi
    else
	if mkdir $1 -p ; then
	    echo "mkdir $1 -p success"
	else
            echo -e "ERR: can't assert dir $1"
            return 0 # ERR
	fi
    fi
    return 1 # OK
}

RemoveDir() {
    if rm -rf $1 ; then
	echo "rm $1 success"
    else
	echo "ERR: rm $1 failed"
    fi
}

GetKernelVersion() {
    if [ -e /tmp/NEW_KERNEL_MARKER ] ; then
	krnl_vers=$(cat /tmp/NEW_KERNEL_MARKER)
    else
	krnl_vers=$(uname -v)
	krnl_vers=${krnl_vers%% *} # cut off everything after ' '
    fi
    krnl_vers=${krnl_vers#*#}  # cut off everything upto '#'
    if [ $krnl_vers -lt 7 ] ; then
	krnl_vers=7;
    fi
    return $krnl_vers
}

CheckVersion() {
  echo "CHECKVERSION: $1 $2"
  GetKernelVersion
  krnl_vers=$?
  if [ $krnl_vers -lt 9 ] ; then
      case "$1" in
	  lng_version)
	      vers_dir="/usr/local/prg/lng"
	      ;;
	  sound_version)
	      vers_dir="/usr/local/prg/sound"
	      ;;
	  guide_version)
	      vers_dir="/usr/local/data/guide"
	      ;;
	  kernel_version)
	      return 1
	      ;;
	  *)
	      vers_dir="/usr/local/data"
	      ;;
      esac
  else
      case "$1" in
	  kernel_version)
	      return 0
	      ;;
	  *)
	      vers_dir="/usr/local/prg/version"
	      ;;
      esac
  fi
  # get curr version
  if [ -e ${vers_dir}/$1 ]; then
      cur_vers=`grep -oe "#[0123456789][0123456789]" ${vers_dir}/$1 |
              grep -oe "[0123456789][0123456789]" | head -n 1` 
  else
      cur_vers=00
      echo -e "set cur_vers to scratch '$cur_vers' \n\r"
  fi
  # get update version
  if [ -e ./viper_version/$1 ]; then
      upd_vers=`grep -oe "#[0123456789][0123456789]" ./viper_version/$1 |
              grep -oe "[0123456789][0123456789]" | head -n 1`
  else
      if [ -e ./$1 ]; then
          upd_vers=`grep -oe "#[0123456789][0123456789]" ./$1 |
              grep -oe "[0123456789][0123456789]" | head -n 1`
      else
          echo -e "version file './viper_version/$1' not found\n\r"
          return 1
      fi
  fi
  # compare version
  echo -e "Compare $1 current version: '"${cur_vers}"' with update version: '"${upd_vers}"' \n\r"
  if  [ $cur_vers -lt $upd_vers ] ; then
      echo -e "update $1 vers.: '"${cur_vers}"' with vers.: '"${upd_vers}"' \n\r"
      return 1
  fi
  if [ ! -z "$2" ] ; then
      if [ "$2" == "-le" -a $cur_vers -eq $upd_vers ] ; then
          echo -e "'-le' is set: update $1 vers.: '"${cur_vers}"' with vers.: '"${upd_vers}"' \n\r"
          return 1
      fi
  fi
  echo -e "$1 vers.: '"${cur_vers}"' is up to date \n\r"
  echo -e "skip $1 update \n\r"
  return 0
}

UpdateManual() {
    languageId=$1
    lighttype=$2
    echo "Update: manual ${languageId}, ${lighttype}"
    if [ ${lighttype} = "iso" ]; then
        fumName="DOC342.${languageId}.80489*.pdf"
        bumName="DOC022.${languageId}.80489*.pdf"
    else
        fumName="DOC342.${languageId}.80488*.pdf"
        bumName="DOC022.${languageId}.80488*.pdf"
    fi
    
    if [ -e /mnt/sda1/manual/${fumName} ]; then
        if cp -f /mnt/sda1/manual/${fumName} /usr/local/data/manuals/. ; then
            echo "Update manual: ${fumName} success"
        else
            echo "Update manual: ${fumName} failed"
            exit $UPD_ERR_NO_SCRIPT
        fi
    else
        if cp -f /mnt/sda1/manual/${bumName} /usr/local/data/manuals/. ; then
            echo "Update manual: ${bumName} success"
        else
            echo "Update manual: ${bumName} failed"
            exit $UPD_ERR_NO_SCRIPT
        fi
    fi
}

KillProcess() {
    pid=$(ps | grep -m 1 $1 | grep -v grep | grep -o '[0-9][^ ]*')
    if [ $pid ] ; then
        echo "KILL: $1 -> $pid"
        kill -9 $pid
    else
        echo "NO KILL: $1 doesn't exist"
    fi
}
