#!/bin/sh
# --------------------------------------------------------
# --- Script:  copy and unpack update driver  ------------
# --- Version: 1.00 --------------------------------------
# --- Datum:   25.09.2010 --------------------------------
# --- Autor:   Max Schreiber / Andre Naggies -------------
# --------------------------------------------------------
##########################################################
# comment out if you don't want to update driver
# exit 0

source ./upd_function.sh

GetKernelVersion
krnl_vers=$?
if [ $krnl_vers -lt 9 ] ; then
    tmpdir=/usr/local/data/tmpdrv
else
    tmpdir=/usr/local/prg/tmpdrv
fi

board_type=$(fw_printenv board | cut -d "=" -f2) > /dev/null 2>&1

pdir=/usr/local/prg

# loesche alte files und lege verzeichnis an
#
AssertDir $tmpdir
if [ $? -eq 0 ] ; then
    echo ERR: $0: AssertDir failed
    exit 6
fi

# kill background processes (otherwise: crash when manipulating dyn libs)
# 
KillProcess start_fusion_receive
KillProcess start_vpn_ssh
KillProcess fusion_receive
KillProcess sshd
KillProcess openvpn

# kopiere Treiberupdate
# STM32
if [ "$board_type" == "stm32mp1" ]; then
    for y in drv_viper_ng drv_fusion_ng ; do
        if [ $y = "drv_viper_ng" -o $1 = "dr3900_ng" -o $1 = "mpptp_ng" -o $1 = "dr6000_ng" -o $1 = "hpptp_ng" ]; then
            echo -e "copy new driver $y.tar.gz ... \n\r"
                if [ -e $y.tar.gz ]; then
                    if cp $y.tar.gz $tmpdir/ ; then
                        echo -e "cp $y.tar.gz file success \n\r"
                        if gzip -d $tmpdir/$y.tar.gz ; then
                            echo -e "gzip $y.tar.gz success \n\r"
                            if tar -xf $tmpdir/$y.tar -C $tmpdir/ ; then
                                echo -e "tar $y.tar success \n\r"
                                if [ -e $tmpdir/$y.sh ]; then
                                    if $tmpdir/$y.sh $1; then
                                        echo -e "$tmpdir/$y.sh success \n\r"
                                    else
                                        echo -e "error script upd_drv_viper.sh (6)\n\r"
                                        exit 6
                                    fi
                                else
                                    echo -e "error script upd_drv_viper.sh (5)\n\r"
                                    exit 5
                                fi
                            else
                                echo -e "error script upd_drv_viper.sh (4)\n\r"
                                exit 4
                            fi
                        else
                            echo -e "error script upd_drv_viper.sh (3)\n\r"
                            exit 3
                        fi
                    else
                        echo -e "error script upd_drv_viper.sh (2)\n\r"
                        exit 2
                    fi
                else
                    echo -e "error script upd_drv_viper.sh (5)\n\r"
                    exit 5
                fi  
        fi
    done
else
    # SH4
    for y in drv_viper drv_fusion ; do
        if [ $y = "drv_viper" -o $1 = "dr3900" -o $1 = "mpptp" -o $1 = "dr6000" -o $1 = "hpptp" ]; then
            echo -e "copy new driver $y.tar.gz ... \n\r"
            if [ -e $y.tar.gz ]; then
                if cp $y.tar.gz $tmpdir/ ; then
                    echo -e "cp $y.tar.gz file success \n\r"
                    if gzip -d $tmpdir/$y.tar.gz ; then
                        echo -e "gzip $y.tar.gz success \n\r"
                        if tar -xf $tmpdir/$y.tar -C $tmpdir/ ; then
                            echo -e "tar $y.tar success \n\r"
                            if [ -e $tmpdir/$y.sh ]; then
                                if $tmpdir/$y.sh $1; then
                                    echo -e "$tmpdir/$y.sh success \n\r"
                                else
                                    echo -e "error script upd_drv_viper.sh (6)\n\r"
                                    exit 6
                                fi
                            else
                                echo -e "error script upd_drv_viper.sh (5)\n\r"
                                exit 5
                            fi
                        else
                            echo -e "error script upd_drv_viper.sh (4)\n\r"
                            exit 4
                        fi
                    else
                        echo -e "error script upd_drv_viper.sh (3)\n\r"
                        exit 3
                    fi
                else
                    echo -e "error script upd_drv_viper.sh (2)\n\r"
                    exit 2
                fi
            else
                echo -e "error script upd_drv_viper.sh (5)\n\r"
                exit 5
            fi
        fi
    done
fi

RemoveDir $tmpdir

# restart fusion
if [ -e $pdir/SW_MARKER_FUSION ]; then
    echo Restart Fusion...
    /etc/init.d/S92-fusion-start
fi

echo -e "end script upd_drv_viper.sh \n\r"
exit 0

